import funkin.menus.ModSwitchMenu;
import funkin.editors.EditorPicker;

import funkin.options.OptionsMenu;
import funkin.menus.credits.CreditsMain;

var nug:FlxSprite;
var curSelected:Float = -1;
var imgGroup:FlxTypedGroup;
var modTxt:FlxSprite;
function create() {
    FlxG.mouse.visible = true;

    imgGroup = new FlxTypedGroup();
    add(imgGroup);

    var images = ["menus/Start", "menus/Options", "menus/Credits"];

    for (i in 0...images.length) {
        var img = new FlxSprite(800, 100 + (i * 200)).loadGraphic(Paths.image(images[i]));
        imgGroup.add(img);
    }
    nug = new FlxSprite(200, 200);
    nug.frames = Paths.getSparrowAtlas('menus/TitleNuggit');
    nug.animation.addByPrefix('idle', 'idle', 24, true);
    nug.animation.addByPrefix('select', 'select', 24, false);
    nug.animation.play("idle");
    add(nug);


    modTxt = new FlxSprite().loadGraphic(Paths.image("menus/Title"));
    modTxt.screenCenter(FlxAxes.X);
    modTxt.scale.set(.65, .65);
    modTxt.alpha = .3;
    add(modTxt);


    CoolUtil.playMusic(Paths.music("tidbit"), true, 1);
}
var canSelect:Bool = true;
function update(elapsed:Float) {
    if(!canSelect) return;
    for (i in 0...imgGroup.length) {
        var img = imgGroup.members[i];

        if (FlxG.mouse.overlaps(img)) img.alpha = 1;
        else if (i != Std.int(curSelected)) img.alpha = 0.5;


        if (FlxG.mouse.overlaps(modTxt)){
            modTxt.alpha = .9; 
        }else {
            modTxt.alpha = .3; 
        }
        if (FlxG.mouse.overlaps(img) && FlxG.mouse.justPressed) {
            curSelected = i;
            for (j in 0...imgGroup.length) {
                if (j != Std.int(curSelected)) imgGroup.members[j].alpha = 0.5;
            }
            canSelect = false;
            img.alpha = 1;
            goToSeclected();
        }
    }
    if (FlxG.keys.justPressed.SEVEN) {
		openSubState(new EditorPicker());
		persistentUpdate = false;
		persistentDraw = true;
	}
    if (controls.SWITCHMOD) {
        openSubState(new ModSwitchMenu());
        persistentUpdate = false;
        persistentDraw = true;
    }
}

function goToSeclected(){
    nug.animation.play("select");
    FlxG.sound.play(Paths.sound('menu/confirm'), 0.4);

    new FlxTimer().start(0.5, function(_) {
        switch(Std.int(curSelected)) {
            case 0:
                
                for (i in 0...imgGroup.length) {
                    FlxTween.tween(imgGroup.members[i], {alpha:0}, 0.5, {ease: FlxEase.circOut});
                }
                FlxTween.tween(modTxt, {alpha:0}, 0.5, {ease: FlxEase.circOut});
                FlxTween.tween(nug, {alpha:0}, 0.5, {ease: FlxEase.circOut});

                new FlxTimer().start(1, function(_) {
                    var warning = new FlxText(0, FlxG.height/2 - 50, FlxG.width, "Warning: If you suffer from epilepsy, play with caution.\nSome shaders may cause discomfort. It is recommended to turn them off.");
                    warning.setFormat(Paths.font("onlyFont.ttf"), 40, FlxColor.RED, "center");
                    add(warning);
                    warning.alpha = 0;
                    FlxTween.tween(warning, {alpha:1}, 0.5, {ease: FlxEase.circOut});

                    
                    new FlxTimer().start(8, function(_) {
                        FlxTween.tween(warning, {alpha:0}, 0.5, {ease: FlxEase.circOut});

                        
                        new FlxTimer().start(0.6, function(_) {
                            trace("Starting Six Piece");    
                            PlayState.loadSong("six-piece", "Hard");
                            FlxG.switchState(new PlayState());
                        });
                    });
                });

            case 1:
                trace("Going to Options");
                FlxG.switchState(new OptionsMenu());
            case 2:
                trace("Going to the Credits");
                FlxG.switchState(new ModState("NugCredits"));
        }
    });
}
